/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.gui;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import technicianlp.reauth.ReflectionHelper;

final class PasswordFieldWidget
extends TextFieldWidget {
    private static final Field selectionEnd = ReflectionHelper.findMcpField(TextFieldWidget.class, "field_146223_s");
    private char[] password = new char[0];

    PasswordFieldWidget(FontRenderer renderer, int posx, int posy, int x, int y, ITextComponent name) {
        super(renderer, posx, posy, x, y, name);
        this.func_146203_f(512);
    }

    public final boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (!this.func_230999_j_() || Screen.func_231169_i_((int)keyCode) || Screen.func_231166_g_((int)keyCode)) {
            return false;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        if (!this.func_212955_f()) {
            return false;
        }
        if (this.isAllowedCharacter(p_charTyped_1_)) {
            this.func_146191_b(Character.toString(p_charTyped_1_));
            return true;
        }
        return false;
    }

    public final void func_146191_b(String rawInput) {
        int selectionEnd = this.getSelectionEnd();
        int selStart = Math.min(this.func_146198_h(), selectionEnd);
        int selEnd = Math.max(this.func_146198_h(), selectionEnd);
        int selLength = selEnd - selStart;
        char[] input = this.filterAllowedCharacters(rawInput);
        char[] newPW = new char[this.password.length - selLength + input.length];
        if (this.password.length != 0 && selStart > 0) {
            System.arraycopy(this.password, 0, newPW, 0, Math.min(selStart, this.password.length));
        }
        System.arraycopy(input, 0, newPW, selStart, input.length);
        if (this.password.length != 0 && selEnd < this.password.length) {
            System.arraycopy(this.password, selEnd, newPW, selStart + input.length, this.password.length - selEnd);
        }
        this.setPassword(newPW);
    }

    public final void func_146175_b(int characterOffset) {
        if (this.password.length == 0) {
            return;
        }
        if (this.getSelectionEnd() != this.func_146198_h()) {
            this.func_146191_b("");
        } else {
            int end;
            int cursor = Util.func_240980_a_((String)this.func_146179_b(), (int)this.func_146198_h(), (int)characterOffset);
            int start = Math.min(cursor, this.func_146198_h());
            if (start != (end = Math.max(cursor, this.func_146198_h()))) {
                char[] newPW = new char[start + this.password.length - end];
                if (start >= 0) {
                    System.arraycopy(this.password, 0, newPW, 0, start);
                }
                if (end < this.password.length) {
                    System.arraycopy(this.password, end, newPW, start, this.password.length - end);
                }
                this.setPassword(newPW);
                this.func_146190_e(start);
            }
        }
    }

    final void setPassword(char[] password) {
        Arrays.fill(this.password, 'f');
        this.password = password;
        this.updateText();
    }

    final char[] getPassword() {
        char[] pw = new char[this.password.length];
        System.arraycopy(this.password, 0, pw, 0, this.password.length);
        return pw;
    }

    public final void func_146180_a(String textIn) {
        this.setPassword(textIn.toCharArray());
        this.updateText();
    }

    private void updateText() {
        char[] chars = new char[this.password.length];
        Arrays.fill(chars, '\u25cf');
        super.func_146180_a(new String(chars));
    }

    private char[] filterAllowedCharacters(String input) {
        char[] out = new char[input.length()];
        int outInd = 0;
        for (int i = 0; i < out.length; ++i) {
            char in = input.charAt(i);
            if (!this.isAllowedCharacter(in)) continue;
            out[outInd++] = in;
        }
        char[] ret = new char[outInd];
        System.arraycopy(out, 0, ret, 0, outInd);
        Arrays.fill(out, 'f');
        return ret;
    }

    private boolean isAllowedCharacter(char in) {
        return in == '\u00a7' || SharedConstants.func_71566_a((char)in);
    }

    public int getSelectionEnd() {
        return (Integer)ReflectionHelper.getField(selectionEnd, (Object)this);
    }

    static {
        Preconditions.checkNotNull((Object)selectionEnd, (Object)"Reflection failed: field_146223_s");
    }
}

